import math
from sage.all import IntegerModRing


def factor(n: int):
    factors: dict[int, int] = {}
    for d in range(2, round(math.sqrt(n)) + 10):
        while n % d == 0:
            n //= d
            if d in factors:
                factors[d] += 1
            else:
                factors[d] = 1
        if n == 1:
            break
    if n != 1:
        factors[n] = 1
    return factors

def mult(n) -> int:
    res: int = 1
    for p in n:
        res *= pow(p, n[p])
    return res

def mult_factors(x, y):
    res = {**x}
    for p in y:
        if p in res:
            res[p] += y[p]
        else:
            res[p] = y[p]
    return res

def multeq_factors(x, y) -> None:
    for p in y:
        if p in x:
            x[p] += y[p]
        else:
            x[p] = y[p]

def phi(n):
    res = {}
    for p in n:
        if n[p] >= 2:
            res[p] = n[p] - 1
    for p in n:
        multeq_factors(res, factor(p-1))
    return res

def solve(N, xs):
    # assert mult(factor(N)) == N
    O = phi(factor(N))
    out = []
    mo = mult(O)
    for x in xs:
        o = {**O}
        for p in o:
            while o[p] != -1 and pow(x, mult(o), N) == 1:
                o[p] -= 1
            
            o[p] += 1
        out.append(mult(o))
        R = IntegerModRing(N)
        assert int(R(x).multiplicative_order()) == mult(o)
    
    return out

# if __name__ == '__main__':
N = int(input())
k = int(input())
xs = [int(input()) for _ in range(k)]
[*map(print, solve(N, xs))]
